#include <allegro.h>

#include "draw.h"
#include "main.h"
#include "actor.h"

#include "sectors.h"
#include "game.h"
#include "shot.h"
#include "man.h"
#include "sfx.h"

#define ACTIVE_SHOTS 64

ACTOR shot[ACTIVE_SHOTS];
int shots_num = 0;

float shot0_points[] = {
	     1.000,      0.000, // 0
	    -8.000,     13.000, // 1
	    11.000,     13.000, // 2
	     0.000,     13.000, // 3
	     0.000,     13.000  // 4
};
int shot0_lines[] = {
	0, 1, 0, 0, 255,
	1, 2, 0, 0, 255,
	2, 0, 0, 0, 255,
	0, 3, 0, 155, 255,
	3, 4, 0, 155, 255,
	4, 0, 0, 155, 255
};
float shot1_points[] = {
	     0.643,      0.000, // 0
	    -5.142,     13.000, // 1
	     7.071,     13.000, // 2
	     6.128,     13.000, // 3
	    -7.660,     13.000  // 4
};
int shot1_lines[] = {
	0, 1, 0, 0, 255,
	1, 2, 0, 0, 255,
	2, 0, 0, 0, 255,
	0, 3, 0, 155, 255,
	3, 4, 0, 155, 255,
	4, 0, 0, 155, 255
};

void shot_process(int num)
{
	ACTOR *actor = &shot[num];
	actor->x += actor->dx;
	actor->y += actor->dy;
	
	if (actor->x > SECTORS * SECTOR_DIMENSION)
		actor->x -= SECTORS * SECTOR_DIMENSION;
		
	if (actor->x < 0)
		actor->x += SECTORS * SECTOR_DIMENSION;
	
	actor->anim++;
	if (actor->anim == 8) {
		actor->anim = 0;
		actor->frame++;
		if (actor->frame == 1) actor->frame = 0;
	}
		
	if (actor->health > 0) {
		int m;
		if (actor->y > 750) actor->health = 0;
		for (m = 0; m < mans_num; m++) {
			if (actor_collide(actor, man[m])) {
				if (man[m]->hit == 0 && man[m]->type == 0) {
					population--;
					if (sound_on) play_sample(sfx_hit, 100, 128, 1000, 0);
				}
				if (man[m]->hit == 0 && man[m]->type == 2) population--;
				if (man[m]->hit == 0 && man[m]->type == 3) population -= 100;
				man[m]->hit = 1;
			}
		}
	}	
	
	actor->dy -= 0.1;
	
	if (actor->y <= 0) {
		shots_num--;
		if (shots_num > 0) {
			*actor = shot[shots_num];
			shot_process(num);
		}
	}
}

static void shot_draw(ACTOR *actor, int x, int y)
{
	if (actor->frame == 0) draw_(x, y, points(shot0), lines(shot0), shot0_points, shot1_points, shot0_lines, actor->anim / 8.0);
	if (actor->frame == 1) draw_(x, y, points(shot1), lines(shot1), shot1_points, shot0_points, shot1_lines, actor->anim / 8.0);
}

ACTOR *shot_init(void)
{
	static int colored = 0;
	static float l, t, r, b;
	static int bound = 0;
	ACTOR *actor;
	if (shots_num == ACTIVE_SHOTS) return NULL;
	actor = &(shot[shots_num]);
	actor_init(actor);
	if (!bound) {
		bound = 1;
		bound_(points(shot0), shot0_points, &l, &t, &r, &b);
		actor->l = l;
		actor->t = t;
		actor->r = r;
		actor->b = b;
	}
	if (!colored) {
		colored = 1;
		color_(lines(shot0), shot0_lines);
	}
	actor->draw = shot_draw;
	
	shots_num++;
	return actor;
}
